﻿using System;
using System.Collections.Generic;
using System.Text;

using Thomas_Erdoesi.Game_Analyzer;
using Thomas_Erdoesi.Properties;

namespace Thomas_Erdoesi.Game_Objects
{
    public class Spaceship : GameObject
    {
        private static byte InternalAngleByte;

        public static bool TurnLeftPending = false;
        public static bool TurnRightPending = false;
        public static bool TurnLeftExecuted = false;
        public static bool TurnRightExecuted = false;

        public Spaceship(int x, int y)
            : base(x, y, Settings.Default.SpaceShipSize)
        {
        }

        public double Angle
        {
            get { return GameConstants.ShipAngle[InternalAngleByte]; }

            set
            {
                double DiffAngle = GameMath.AngleDiff(Angle, value);

                if (Math.Abs(DiffAngle) < 0.2) return;

                while (Math.Abs(GameMath.AngleDiff(Angle, value)) > 0.05)
                {
                    unchecked
                    {
                        InternalAngleByte += (byte)Math.Sign(DiffAngle);
                    }
                }
            }
        }

        public double PredictedAngle
        {
            get
            {
                byte PredictedAngleByte = InternalAngleByte;

                unchecked
                {
                    if (TurnLeftPending) PredictedAngleByte++;
                    if (TurnRightPending) PredictedAngleByte--;
                }

                return GameConstants.ShipAngle[PredictedAngleByte];
            }
        }

        public double PredictAngle(int TurnSteps)
        {
            unchecked
            {
                byte PredictedAngleByte = (byte)(InternalAngleByte + TurnSteps);
                return GameConstants.ShipAngle[PredictedAngleByte];
            }
        }

        public byte AngleByte
        {
            get { return InternalAngleByte; }
            set { InternalAngleByte = value; }
        }
    }
}
